#!/bin/bash
cabecera() {
    echo "#######################################################################"
    echo "#                     Script Instalacion Scrapy                       #"
    echo "#                                                                     #"
    echo "#                     Autor: Rafael Herrero                           #"
    echo "#                     rafahsolis@gmail.com                            #"
    echo "#                     Version archivo:01-ENE-2015                       #"
    echo "#######################################################################"
}


SCRAPY_VIRTUALENV_PATH=$HOME/.virtualEnv/scrapyVirtualenv

DEPENDENCIAS=(libxml2-dev\
              libxslt-dev\
              python-dev\
              libblas-dev\
              liblapack-dev\
              libffi-dev\
              python-lxml\
              libssl-dev\
)


PIPS=(lxml\
      Scrapy\
      w3lib\
      SQLAlchemy\
)


debInst() {
    dpkg-query -Wf'${db:Status-abbrev}' "$1" 2>/dev/null | grep -q '^i'
}


installScrapyVirtualenv() {
    echo Instalando virtualenv
    echo Se creara el entorno virtual $SCRAPY_VIRTUALENV_PATH
    echo Para activarlo: source $SCRAPY_VIRTUALENV_PATH/bin/activate
    sudo apt-get install python-virtualenv
    if [ ! -d $HOME/.virtualEnv ] ; then
        mkdir $HOME/.virtualEnv
    fi
    virtualenv $SCRAPY_VIRTUALENV_PATH
}


comprobarDependencias() {
    echo Comprobando dependencias...
    for dependencia in "${DEPENDENCIAS[@]}"; do
        if debInst "$dependencia"; then
            echo $dependencia [ok]
        else
            echo Instalando paquete $dependencia
            sudo apt-get install $dependencia
        fi
    done
}


instPips() {
    source $SCRAPY_VIRTUALENV_PATH/bin/activate
    which pip
    sleep 10
    for p in "${PIPS[@]}"; do
        pip install $p
    done
}

clear
cabecera
echo "This program will install Scrapy in a virtual enviroment at: " $SCRAPY_VIRTUALENV_PATH
comprobarDependencias
installScrapyVirtualenv
instPips

